/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializationContextDefault;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.ObjectConstructor;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfoCollection;
import com.google.gson.TypeInfoMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultTypeAdapters {
    private static final DefaultDateTypeAdapter DATE_TYPE_ADAPTER = new DefaultDateTypeAdapter(DateFormat.getDateTimeInstance());
    private static final EnumTypeAdapter ENUM_TYPE_ADAPTER = new EnumTypeAdapter();
    private static final UrlTypeAdapter URL_TYPE_ADAPTER = new UrlTypeAdapter();
    private static final UriTypeAdapter URI_TYPE_ADAPTER = new UriTypeAdapter();
    private static final LocaleTypeAdapter LOCALE_TYPE_ADAPTER = new LocaleTypeAdapter();
    private static final CollectionTypeAdapter COLLECTION_TYPE_ADAPTER = new CollectionTypeAdapter();
    private static final MapTypeAdapter MAP_TYPE_ADAPTER = new MapTypeAdapter();
    private static final BigDecimalTypeAdapter BIG_DECIMAL_TYPE_ADAPTER = new BigDecimalTypeAdapter();
    private static final BigIntegerTypeAdapter BIG_INTEGER_TYPE_ADAPTER = new BigIntegerTypeAdapter();
    private static final BooleanTypeAdapter BOOLEAN_TYPE_ADAPTER = new BooleanTypeAdapter();
    private static final ByteTypeAdapter BYTE_TYPE_ADAPTER = new ByteTypeAdapter();
    private static final CharacterTypeAdapter CHARACTER_TYPE_ADAPTER = new CharacterTypeAdapter();
    private static final DoubleTypeAdapter DOUBLE_TYPE_ADAPTER = new DoubleTypeAdapter();
    private static final FloatTypeAdapter FLOAT_TYPE_ADAPTER = new FloatTypeAdapter();
    private static final IntegerTypeAdapter INTEGER_TYPE_ADAPTER = new IntegerTypeAdapter();
    private static final LongTypeAdapter LONG_TYPE_ADAPTER = new LongTypeAdapter();
    private static final ShortTypeAdapter SHORT_TYPE_ADAPTER = new ShortTypeAdapter();
    private static final StringTypeAdapter STRING_TYPE_ADAPTER = new StringTypeAdapter();
    private static final LinkedListCreator LINKED_LIST_CREATOR = new LinkedListCreator();
    private static final TreeSetCreator TREE_SET_CREATOR = new TreeSetCreator();
    static final ParameterizedTypeHandlerMap<JsonSerializer<?>> DEFAULT_SERIALIZERS = DefaultTypeAdapters.getDefaultSerializers();
    static final ParameterizedTypeHandlerMap<JsonDeserializer<?>> DEFAULT_DESERIALIZERS = DefaultTypeAdapters.getDefaultDeserializers();
    static final ParameterizedTypeHandlerMap<InstanceCreator<?>> DEFAULT_INSTANCE_CREATORS = DefaultTypeAdapters.getDefaultInstanceCreators();

    DefaultTypeAdapters() {
    }

    private static ParameterizedTypeHandlerMap<JsonSerializer<?>> getDefaultSerializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), ENUM_TYPE_ADAPTER);
        map.register((Type)((Object)URL.class), URL_TYPE_ADAPTER);
        map.register((Type)((Object)URI.class), URI_TYPE_ADAPTER);
        map.register((Type)((Object)Locale.class), LOCALE_TYPE_ADAPTER);
        map.register((Type)((Object)Collection.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)Map.class), MAP_TYPE_ADAPTER);
        map.register((Type)((Object)Date.class), DATE_TYPE_ADAPTER);
        map.register((Type)((Object)BigDecimal.class), BIG_DECIMAL_TYPE_ADAPTER);
        map.register((Type)((Object)BigInteger.class), BIG_INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Boolean.class), BOOLEAN_TYPE_ADAPTER);
        map.register(Boolean.TYPE, BOOLEAN_TYPE_ADAPTER);
        map.register((Type)((Object)Byte.class), BYTE_TYPE_ADAPTER);
        map.register(Byte.TYPE, BYTE_TYPE_ADAPTER);
        map.register((Type)((Object)Character.class), CHARACTER_TYPE_ADAPTER);
        map.register(Character.TYPE, CHARACTER_TYPE_ADAPTER);
        map.register((Type)((Object)Double.class), DOUBLE_TYPE_ADAPTER);
        map.register(Double.TYPE, DOUBLE_TYPE_ADAPTER);
        map.register((Type)((Object)Float.class), FLOAT_TYPE_ADAPTER);
        map.register(Float.TYPE, FLOAT_TYPE_ADAPTER);
        map.register((Type)((Object)Integer.class), INTEGER_TYPE_ADAPTER);
        map.register(Integer.TYPE, INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Long.class), LONG_TYPE_ADAPTER);
        map.register(Long.TYPE, LONG_TYPE_ADAPTER);
        map.register((Type)((Object)Short.class), SHORT_TYPE_ADAPTER);
        map.register(Short.TYPE, SHORT_TYPE_ADAPTER);
        map.register((Type)((Object)String.class), STRING_TYPE_ADAPTER);
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<JsonDeserializer<?>> getDefaultDeserializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), DefaultTypeAdapters.wrapDeserializer(ENUM_TYPE_ADAPTER));
        map.register((Type)((Object)URL.class), DefaultTypeAdapters.wrapDeserializer(URL_TYPE_ADAPTER));
        map.register((Type)((Object)URI.class), DefaultTypeAdapters.wrapDeserializer(URI_TYPE_ADAPTER));
        map.register((Type)((Object)Locale.class), DefaultTypeAdapters.wrapDeserializer(LOCALE_TYPE_ADAPTER));
        map.register((Type)((Object)Collection.class), DefaultTypeAdapters.wrapDeserializer(COLLECTION_TYPE_ADAPTER));
        map.register((Type)((Object)Map.class), DefaultTypeAdapters.wrapDeserializer(MAP_TYPE_ADAPTER));
        map.register((Type)((Object)Date.class), DefaultTypeAdapters.wrapDeserializer(DATE_TYPE_ADAPTER));
        map.register((Type)((Object)BigDecimal.class), DefaultTypeAdapters.wrapDeserializer(BIG_DECIMAL_TYPE_ADAPTER));
        map.register((Type)((Object)BigInteger.class), DefaultTypeAdapters.wrapDeserializer(BIG_INTEGER_TYPE_ADAPTER));
        map.register((Type)((Object)Boolean.class), DefaultTypeAdapters.wrapDeserializer(BOOLEAN_TYPE_ADAPTER));
        map.register(Boolean.TYPE, DefaultTypeAdapters.wrapDeserializer(BOOLEAN_TYPE_ADAPTER));
        map.register((Type)((Object)Byte.class), DefaultTypeAdapters.wrapDeserializer(BYTE_TYPE_ADAPTER));
        map.register(Byte.TYPE, DefaultTypeAdapters.wrapDeserializer(BYTE_TYPE_ADAPTER));
        map.register((Type)((Object)Character.class), DefaultTypeAdapters.wrapDeserializer(CHARACTER_TYPE_ADAPTER));
        map.register(Character.TYPE, DefaultTypeAdapters.wrapDeserializer(CHARACTER_TYPE_ADAPTER));
        map.register((Type)((Object)Double.class), DefaultTypeAdapters.wrapDeserializer(DOUBLE_TYPE_ADAPTER));
        map.register(Double.TYPE, DefaultTypeAdapters.wrapDeserializer(DOUBLE_TYPE_ADAPTER));
        map.register((Type)((Object)Float.class), DefaultTypeAdapters.wrapDeserializer(FLOAT_TYPE_ADAPTER));
        map.register(Float.TYPE, DefaultTypeAdapters.wrapDeserializer(FLOAT_TYPE_ADAPTER));
        map.register((Type)((Object)Integer.class), DefaultTypeAdapters.wrapDeserializer(INTEGER_TYPE_ADAPTER));
        map.register(Integer.TYPE, DefaultTypeAdapters.wrapDeserializer(INTEGER_TYPE_ADAPTER));
        map.register((Type)((Object)Long.class), DefaultTypeAdapters.wrapDeserializer(LONG_TYPE_ADAPTER));
        map.register(Long.TYPE, DefaultTypeAdapters.wrapDeserializer(LONG_TYPE_ADAPTER));
        map.register((Type)((Object)Short.class), DefaultTypeAdapters.wrapDeserializer(SHORT_TYPE_ADAPTER));
        map.register(Short.TYPE, DefaultTypeAdapters.wrapDeserializer(SHORT_TYPE_ADAPTER));
        map.register((Type)((Object)String.class), DefaultTypeAdapters.wrapDeserializer(STRING_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<InstanceCreator<?>> getDefaultInstanceCreators() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), ENUM_TYPE_ADAPTER);
        map.register((Type)((Object)URL.class), URL_TYPE_ADAPTER);
        map.register((Type)((Object)Locale.class), LOCALE_TYPE_ADAPTER);
        map.register((Type)((Object)Map.class), MAP_TYPE_ADAPTER);
        map.register((Type)((Object)BigDecimal.class), BIG_DECIMAL_TYPE_ADAPTER);
        map.register((Type)((Object)BigInteger.class), BIG_INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Boolean.class), BOOLEAN_TYPE_ADAPTER);
        map.register(Boolean.TYPE, BOOLEAN_TYPE_ADAPTER);
        map.register((Type)((Object)Byte.class), BYTE_TYPE_ADAPTER);
        map.register(Byte.TYPE, BYTE_TYPE_ADAPTER);
        map.register((Type)((Object)Character.class), CHARACTER_TYPE_ADAPTER);
        map.register(Character.TYPE, CHARACTER_TYPE_ADAPTER);
        map.register((Type)((Object)Double.class), DOUBLE_TYPE_ADAPTER);
        map.register(Double.TYPE, DOUBLE_TYPE_ADAPTER);
        map.register((Type)((Object)Float.class), FLOAT_TYPE_ADAPTER);
        map.register(Float.TYPE, FLOAT_TYPE_ADAPTER);
        map.register((Type)((Object)Integer.class), INTEGER_TYPE_ADAPTER);
        map.register(Integer.TYPE, INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Long.class), LONG_TYPE_ADAPTER);
        map.register(Long.TYPE, LONG_TYPE_ADAPTER);
        map.register((Type)((Object)Short.class), SHORT_TYPE_ADAPTER);
        map.register(Short.TYPE, SHORT_TYPE_ADAPTER);
        map.register((Type)((Object)String.class), STRING_TYPE_ADAPTER);
        map.register((Type)((Object)Collection.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)List.class), LINKED_LIST_CREATOR);
        map.register((Type)((Object)Queue.class), LINKED_LIST_CREATOR);
        map.register((Type)((Object)Set.class), TREE_SET_CREATOR);
        map.register((Type)((Object)SortedSet.class), TREE_SET_CREATOR);
        map.makeUnmodifiable();
        return map;
    }

    private static JsonDeserializer<?> wrapDeserializer(JsonDeserializer<?> deserializer) {
        return new JsonDeserializerExceptionWrapper(deserializer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeSetCreator
    implements InstanceCreator<TreeSet<?>> {
        private TreeSetCreator() {
        }

        @Override
        public TreeSet<?> createInstance(Type type) {
            return new TreeSet();
        }

        public String toString() {
            return TreeSetCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedListCreator
    implements InstanceCreator<LinkedList<?>> {
        private LinkedListCreator() {
        }

        @Override
        public LinkedList<?> createInstance(Type type) {
            return new LinkedList();
        }

        public String toString() {
            return LinkedListCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanTypeAdapter
    implements InstanceCreator<Boolean>,
    JsonSerializer<Boolean>,
    JsonDeserializer<Boolean> {
        private BooleanTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Boolean src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBoolean();
        }

        @Override
        public Boolean createInstance(Type type) {
            return new Boolean(false);
        }

        public String toString() {
            return BooleanTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringTypeAdapter
    implements InstanceCreator<String>,
    JsonSerializer<String>,
    JsonDeserializer<String> {
        private StringTypeAdapter() {
        }

        @Override
        public JsonElement serialize(String src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsString();
        }

        @Override
        public String createInstance(Type type) {
            return "";
        }

        public String toString() {
            return StringTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterTypeAdapter
    implements InstanceCreator<Character>,
    JsonSerializer<Character>,
    JsonDeserializer<Character> {
        private CharacterTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Character src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Character deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Character.valueOf(json.getAsCharacter());
        }

        @Override
        public Character createInstance(Type type) {
            return new Character('0');
        }

        public String toString() {
            return CharacterTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleTypeAdapter
    implements InstanceCreator<Double>,
    JsonSerializer<Double>,
    JsonDeserializer<Double> {
        private DoubleTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsDouble();
        }

        @Override
        public Double createInstance(Type type) {
            return new Double(0.0);
        }

        public String toString() {
            return DoubleTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatTypeAdapter
    implements InstanceCreator<Float>,
    JsonSerializer<Float>,
    JsonDeserializer<Float> {
        private FloatTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Float src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Float.valueOf(json.getAsFloat());
        }

        @Override
        public Float createInstance(Type type) {
            return new Float(0.0f);
        }

        public String toString() {
            return FloatTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteTypeAdapter
    implements InstanceCreator<Byte>,
    JsonSerializer<Byte>,
    JsonDeserializer<Byte> {
        private ByteTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Byte src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Byte deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsByte();
        }

        @Override
        public Byte createInstance(Type type) {
            return new Byte(0);
        }

        public String toString() {
            return ByteTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortTypeAdapter
    implements InstanceCreator<Short>,
    JsonSerializer<Short>,
    JsonDeserializer<Short> {
        private ShortTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Short src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Short deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsShort();
        }

        @Override
        public Short createInstance(Type type) {
            return new Short(0);
        }

        public String toString() {
            return ShortTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerTypeAdapter
    implements InstanceCreator<Integer>,
    JsonSerializer<Integer>,
    JsonDeserializer<Integer> {
        private IntegerTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsInt();
        }

        @Override
        public Integer createInstance(Type type) {
            return new Integer(0);
        }

        public String toString() {
            return IntegerTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongTypeAdapter
    implements InstanceCreator<Long>,
    JsonSerializer<Long>,
    JsonDeserializer<Long> {
        private LongTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsLong();
        }

        @Override
        public Long createInstance(Type type) {
            return new Long(0L);
        }

        public String toString() {
            return LongTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigIntegerTypeAdapter
    implements JsonSerializer<BigInteger>,
    JsonDeserializer<BigInteger>,
    InstanceCreator<BigInteger> {
        private BigIntegerTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigInteger src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigInteger deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigInteger();
        }

        @Override
        public BigInteger createInstance(Type type) {
            return new BigInteger("0");
        }

        public String toString() {
            return BigIntegerTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigDecimalTypeAdapter
    implements JsonSerializer<BigDecimal>,
    JsonDeserializer<BigDecimal>,
    InstanceCreator<BigDecimal> {
        private BigDecimalTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigDecimal src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigDecimal deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigDecimal();
        }

        @Override
        public BigDecimal createInstance(Type type) {
            return new BigDecimal(0);
        }

        public String toString() {
            return BigDecimalTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapTypeAdapter
    implements JsonSerializer<Map>,
    JsonDeserializer<Map>,
    InstanceCreator<Map> {
        MapTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Map src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject map = new JsonObject();
            Class<?> childGenericType = null;
            if (typeOfSrc instanceof ParameterizedType) {
                childGenericType = new TypeInfoMap(typeOfSrc).getValueType();
            }
            for (Map.Entry entry : src.entrySet()) {
                Class<?> childType;
                Object value = entry.getValue();
                childType = childGenericType == null ? (childType = value.getClass()) : childGenericType;
                JsonElement valueElement = context.serialize(value, childType);
                map.add(entry.getKey().toString(), valueElement);
            }
            return map;
        }

        @Override
        public Map deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map map = this.constructMapType(typeOfT, context);
            Type childType = new TypeInfoMap(typeOfT).getValueType();
            for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                Object value = context.deserialize(entry.getValue(), childType);
                map.put(entry.getKey(), value);
            }
            return map;
        }

        private Map constructMapType(Type mapType, JsonDeserializationContext context) {
            JsonDeserializationContextDefault contextImpl = (JsonDeserializationContextDefault)context;
            ObjectConstructor objectConstructor = contextImpl.getObjectConstructor();
            return (Map)objectConstructor.construct(mapType);
        }

        @Override
        public Map createInstance(Type type) {
            return new LinkedHashMap();
        }

        public String toString() {
            return MapTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionTypeAdapter
    implements JsonSerializer<Collection>,
    JsonDeserializer<Collection>,
    InstanceCreator<Collection> {
        private CollectionTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Collection src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return JsonNull.INSTANCE;
            }
            JsonArray array = new JsonArray();
            Class<?> childGenericType = null;
            if (typeOfSrc instanceof ParameterizedType) {
                childGenericType = new TypeInfoCollection(typeOfSrc).getElementType();
            }
            for (Object child : src) {
                Class<?> childType;
                childType = childGenericType == null ? (childType = child.getClass()) : childGenericType;
                JsonElement element = context.serialize(child, childType);
                array.add(element);
            }
            return array;
        }

        @Override
        public Collection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            Collection collection = this.constructCollectionType(typeOfT, context);
            Type childType = new TypeInfoCollection(typeOfT).getElementType();
            for (JsonElement childElement : json.getAsJsonArray()) {
                if (childElement == null || childElement.isJsonNull()) {
                    collection.add(null);
                    continue;
                }
                Object value = context.deserialize(childElement, childType);
                collection.add(value);
            }
            return collection;
        }

        private Collection constructCollectionType(Type collectionType, JsonDeserializationContext context) {
            JsonDeserializationContextDefault contextImpl = (JsonDeserializationContextDefault)context;
            ObjectConstructor objectConstructor = contextImpl.getObjectConstructor();
            return (Collection)objectConstructor.construct(collectionType);
        }

        @Override
        public Collection createInstance(Type type) {
            return new LinkedList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleTypeAdapter
    implements JsonSerializer<Locale>,
    JsonDeserializer<Locale>,
    InstanceCreator<Locale> {
        private LocaleTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Locale src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        public Locale deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String locale = json.getAsString();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        @Override
        public Locale createInstance(Type type) {
            return new Locale("en_US");
        }

        public String toString() {
            return LocaleTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UriTypeAdapter
    implements JsonSerializer<URI>,
    JsonDeserializer<URI> {
        private UriTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URI src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toASCIIString());
        }

        @Override
        public URI deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URI(json.getAsString());
            }
            catch (URISyntaxException e) {
                throw new JsonParseException(e);
            }
        }

        public String toString() {
            return UriTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlTypeAdapter
    implements JsonSerializer<URL>,
    JsonDeserializer<URL>,
    InstanceCreator<URL> {
        private UrlTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URL src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toExternalForm());
        }

        @Override
        public URL deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URL(json.getAsString());
            }
            catch (MalformedURLException e) {
                throw new JsonParseException(e);
            }
        }

        @Override
        public URL createInstance(Type type) {
            try {
                return new URL("http://google.com/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return UrlTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumTypeAdapter<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T>,
    InstanceCreator<Enum<?>> {
        private EnumTypeAdapter() {
        }

        @Override
        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).name());
        }

        @Override
        public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }

        @Override
        public Enum<?> createInstance(Type type) {
            Class enumClass = (Class)type;
            try {
                Method valuesMethod = enumClass.getMethod("values", new Class[0]);
                Enum[] enums = (Enum[])valuesMethod.invoke(null, new Object[0]);
                return enums[0];
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return EnumTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultDateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat format;

        public DefaultDateTypeAdapter(String datePattern) {
            this.format = new SimpleDateFormat(datePattern);
        }

        DefaultDateTypeAdapter(DateFormat format) {
            this.format = format;
        }

        public DefaultDateTypeAdapter(int style) {
            this.format = DateFormat.getDateInstance(style);
        }

        public DefaultDateTypeAdapter(int dateStyle, int timeStyle) {
            this.format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        }

        @Override
        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            String dateFormatAsString = this.format.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }

        @Override
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("The date should be a string value");
            }
            try {
                return this.format.parse(json.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(DefaultDateTypeAdapter.class.getSimpleName());
            sb.append('(').append(this.format.getClass().getSimpleName()).append(')');
            return sb.toString();
        }
    }
}

