/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DefaultTypeAdapters;
import com.google.gson.DisjunctionExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.ExposeAnnotationBasedExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.InnerClassExclusionStrategy;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonPrintFormatter;
import com.google.gson.JsonSerializer;
import com.google.gson.MappedObjectConstructor;
import com.google.gson.ModifierBasedExclusionStrategy;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import com.google.gson.VersionExclusionStrategy;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GsonBuilder {
    private double ignoreVersionsAfter = -1.0;
    private ModifierBasedExclusionStrategy modifierBasedExclusionStrategy;
    private final InnerClassExclusionStrategy innerClassExclusionStrategy = new InnerClassExclusionStrategy();
    private boolean excludeFieldsWithoutExposeAnnotation = false;
    private JsonFormatter formatter;
    private FieldNamingStrategy fieldNamingPolicy;
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private boolean serializeNulls = false;
    private String datePattern;
    private int dateStyle = 2;
    private int timeStyle = 2;

    public GsonBuilder() {
        this.modifierBasedExclusionStrategy = Gson.DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY;
        this.formatter = Gson.DEFAULT_JSON_FORMATTER;
        this.fieldNamingPolicy = Gson.DEFAULT_NAMING_POLICY;
        this.instanceCreators = new ParameterizedTypeHandlerMap();
        this.serializers = new ParameterizedTypeHandlerMap();
        this.deserializers = new ParameterizedTypeHandlerMap();
    }

    public GsonBuilder setVersion(double ignoreVersionsAfter) {
        this.ignoreVersionsAfter = ignoreVersionsAfter;
        return this;
    }

    public GsonBuilder excludeFieldsWithModifiers(int ... modifiers) {
        boolean skipSynthetics = true;
        this.modifierBasedExclusionStrategy = new ModifierBasedExclusionStrategy(skipSynthetics, modifiers);
        return this;
    }

    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excludeFieldsWithoutExposeAnnotation = true;
        return this;
    }

    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        return this.setFieldNamingStrategy(namingConvention.getFieldNamingPolicy());
    }

    private GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingPolicy) {
        this.fieldNamingPolicy = new SerializedNameAnnotationInterceptingNamingPolicy(fieldNamingPolicy);
        return this;
    }

    public GsonBuilder setPrettyPrinting() {
        this.setFormatter(new JsonPrintFormatter());
        return this;
    }

    GsonBuilder setFormatter(JsonFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public GsonBuilder setDateFormat(String pattern) {
        this.datePattern = pattern;
        return this;
    }

    public GsonBuilder setDateFormat(int style) {
        this.dateStyle = style;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator);
        if (typeAdapter instanceof InstanceCreator) {
            this.registerInstanceCreator(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer) {
            this.registerSerializer(type, (JsonSerializer)typeAdapter);
        }
        if (typeAdapter instanceof JsonDeserializer) {
            this.registerDeserializer(type, (JsonDeserializer)typeAdapter);
        }
        return this;
    }

    private <T> GsonBuilder registerInstanceCreator(Type typeOfT, InstanceCreator<? extends T> instanceCreator) {
        this.instanceCreators.register(typeOfT, instanceCreator);
        return this;
    }

    private <T> GsonBuilder registerSerializer(Type typeOfT, JsonSerializer<T> serializer) {
        this.serializers.register(typeOfT, serializer);
        return this;
    }

    private <T> GsonBuilder registerDeserializer(Type typeOfT, JsonDeserializer<T> deserializer) {
        this.deserializers.register(typeOfT, new JsonDeserializerExceptionWrapper<T>(deserializer));
        return this;
    }

    public Gson create() {
        LinkedList<ExclusionStrategy> strategies = new LinkedList<ExclusionStrategy>();
        strategies.add(this.innerClassExclusionStrategy);
        strategies.add(this.modifierBasedExclusionStrategy);
        if (this.ignoreVersionsAfter != -1.0) {
            strategies.add(new VersionExclusionStrategy(this.ignoreVersionsAfter));
        }
        if (this.excludeFieldsWithoutExposeAnnotation) {
            strategies.add(new ExposeAnnotationBasedExclusionStrategy());
        }
        DisjunctionExclusionStrategy exclusionStrategy = new DisjunctionExclusionStrategy(strategies);
        ParameterizedTypeHandlerMap<JsonSerializer<?>> customSerializers = this.serializers.copyOf();
        ParameterizedTypeHandlerMap<JsonDeserializer<?>> customDeserializers = this.deserializers.copyOf();
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, customSerializers, customDeserializers);
        customSerializers.registerIfAbsent(DefaultTypeAdapters.DEFAULT_SERIALIZERS);
        customDeserializers.registerIfAbsent(DefaultTypeAdapters.DEFAULT_DESERIALIZERS);
        ParameterizedTypeHandlerMap<InstanceCreator<?>> customInstanceCreators = this.instanceCreators.copyOf();
        customInstanceCreators.registerIfAbsent(DefaultTypeAdapters.DEFAULT_INSTANCE_CREATORS);
        MappedObjectConstructor objConstructor = Gson.createObjectConstructor(customInstanceCreators);
        Gson gson = new Gson(exclusionStrategy, this.fieldNamingPolicy, objConstructor, this.formatter, this.serializeNulls, customSerializers, customDeserializers);
        return gson;
    }

    private static void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers) {
        DefaultTypeAdapters.DefaultDateTypeAdapter dateTypeAdapter = null;
        if (datePattern != null && !"".equals(datePattern.trim())) {
            dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(datePattern);
        } else if (dateStyle != 2 && timeStyle != 2) {
            dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(dateStyle, timeStyle);
        }
        if (dateTypeAdapter != null && !serializers.hasAnyHandlerFor((Type)((Object)Date.class)) && !deserializers.hasAnyHandlerFor((Type)((Object)Date.class))) {
            serializers.register((Type)((Object)Date.class), dateTypeAdapter);
            deserializers.register((Type)((Object)Date.class), dateTypeAdapter);
        }
    }
}

