/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Provider;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.BrowserShutdownAction;
import com.google.jstestdriver.BrowserStartupAction;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FailureCheckerAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ServerShutdownAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.SimpleProcessFactory;
import com.google.jstestdriver.ThreadedAction;
import com.google.jstestdriver.ThreadedActionsRunner;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.output.PrintXmlTestResultsAction;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSequenceBuilder {
    private final ActionFactory actionFactory;
    private final FileLoader fileLoader;
    private final Provider<List<ThreadedAction>> threadedActionProvider;
    private final Provider<JsTestDriverClient> clientProvider;
    private final Provider<URLTranslator> urlTranslatorProvider;
    private final Provider<URLRewriter> urlRewriterProvider;
    private final FailureAccumulator accumulator;
    private List<String> browsers = new LinkedList<String>();
    private CapturedBrowsers capturedBrowsers = new CapturedBrowsers();
    private HashMap<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    private Set<FileInfo> fileSet;
    private int localServerPort = -1;
    private boolean preloadFiles = false;
    private String remoteServerAddress;
    private boolean reset;
    private List<String> tests = new LinkedList<String>();
    private List<String> dryRunFor = new LinkedList<String>();
    private List<ThreadedAction> threadedActions;
    private List<String> commands = new LinkedList<String>();
    private XmlPrinter xmlPrinter;

    public ActionSequenceBuilder(ActionFactory actionFactory, FileLoader fileLoader, ResponseStreamFactory responseStreamFactory, Provider<List<ThreadedAction>> provider, Provider<JsTestDriverClient> provider2, Provider<URLTranslator> provider3, Provider<URLRewriter> provider4, FailureAccumulator failureAccumulator) {
        this.actionFactory = actionFactory;
        this.fileLoader = fileLoader;
        this.threadedActionProvider = provider;
        this.clientProvider = provider2;
        this.urlTranslatorProvider = provider3;
        this.urlRewriterProvider = provider4;
        this.accumulator = failureAccumulator;
    }

    private void addBrowserControlActions(List<Action> list) {
        if (!this.browsers.isEmpty()) {
            BrowserStartupAction browserStartupAction = new BrowserStartupAction(this.browsers, this.remoteServerAddress, new SimpleProcessFactory(), new CountDownLatch(this.browsers.size()));
            this.capturedBrowsers.addObserver(browserStartupAction);
            list.add(0, browserStartupAction);
            if (!this.leaveServerRunning()) {
                list.add(new BrowserShutdownAction(browserStartupAction));
            }
        }
    }

    private void addServerActions(List<Action> list, boolean bl) {
        if (this.preloadFiles) {
            for (FileInfo fileInfo : this.fileLoader.loadFiles(this.fileSet, true)) {
                this.files.put(fileInfo.getFileName(), fileInfo);
            }
        }
        ServerStartupAction serverStartupAction = this.actionFactory.getServerStartupAction(this.localServerPort, this.capturedBrowsers, new FilesCache(this.files), this.urlTranslatorProvider.get(), this.urlRewriterProvider.get());
        list.add(0, serverStartupAction);
        if (!bl) {
            list.add(new ServerShutdownAction(serverStartupAction));
        }
    }

    public ActionSequenceBuilder addTests(List<String> list) {
        this.tests.addAll(list);
        return this;
    }

    public ActionSequenceBuilder asDryRunFor(List<String> list) {
        this.dryRunFor.addAll(list);
        return this;
    }

    public List<Action> build() {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        JsTestDriverClient jsTestDriverClient = this.clientProvider.get();
        this.threadedActions = this.threadedActionProvider.get();
        if (!this.threadedActions.isEmpty()) {
            linkedList.add(new ThreadedActionsRunner(jsTestDriverClient, this.threadedActions, Executors.newCachedThreadPool()));
        }
        if (this.xmlPrinter != null) {
            linkedList.add(new PrintXmlTestResultsAction(this.xmlPrinter));
        }
        this.addBrowserControlActions(linkedList);
        if (this.needToStartServer()) {
            this.addServerActions(linkedList, this.leaveServerRunning());
        }
        linkedList.add(new FailureCheckerAction(this.accumulator));
        return linkedList;
    }

    private boolean leaveServerRunning() {
        return this.tests.isEmpty() && this.commands.isEmpty() && !this.reset && this.dryRunFor.isEmpty();
    }

    private boolean needToStartServer() {
        return this.localServerPort != -1;
    }

    public ActionSequenceBuilder onBrowsers(List<String> list) {
        this.browsers.addAll(list);
        return this;
    }

    public ActionSequenceBuilder reset(boolean bl) {
        this.reset = bl;
        return this;
    }

    public ActionSequenceBuilder usingFiles(Set<FileInfo> set, boolean bl) {
        this.fileSet = set;
        this.preloadFiles = bl;
        return this;
    }

    public ActionSequenceBuilder withLocalServerPort(int n) {
        this.localServerPort = n;
        return this;
    }

    public ActionSequenceBuilder withRemoteServer(String string) {
        this.remoteServerAddress = string;
        return this;
    }

    public ActionSequenceBuilder addCommands(List<String> list) {
        this.commands.addAll(list);
        return this;
    }

    public ActionSequenceBuilder printingResultsWhenFinished(XmlPrinter xmlPrinter) {
        this.xmlPrinter = xmlPrinter;
        return this;
    }
}

