/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.TimeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserHunter {
    private static final Logger logger = LoggerFactory.getLogger(BrowserHunter.class.getName());
    private static final String REMOTE_CONSOLE_RUNNER = "/slave/%s/RemoteConsoleRunner%s.html";
    private final CapturedBrowsers capturedBrowsers;

    public BrowserHunter(CapturedBrowsers capturedBrowsers) {
        this.capturedBrowsers = capturedBrowsers;
    }

    public SlaveBrowser captureBrowser(String string, String string2, String string3) {
        return this.captureBrowser(this.capturedBrowsers.getUniqueId(), string, string2, string3);
    }

    public String getCaptureUrl(String string, String string2) {
        return String.format(REMOTE_CONSOLE_RUNNER, string, string2);
    }

    public SlaveBrowser captureBrowser(String string, String string2, String string3, String string4) {
        BrowserInfo browserInfo = new BrowserInfo();
        browserInfo.setId(Integer.valueOf(string));
        browserInfo.setName(string2);
        browserInfo.setVersion(string3);
        browserInfo.setOs(string4);
        SlaveBrowser slaveBrowser = new SlaveBrowser(new TimeImpl(), string, browserInfo);
        this.capturedBrowsers.addSlave(slaveBrowser);
        logger.info("Browser Captured: {} version {} ({})", new Object[]{string2, string3, string});
        return slaveBrowser;
    }

    public boolean isBrowserCaptured(String string) {
        return this.capturedBrowsers.getBrowser(string) != null;
    }

    public void freeBrowser(String string) {
        this.capturedBrowsers.removeSlave(string);
    }
}

