/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserStartupAction;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserShutdownAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserShutdownAction.class);
    private final BrowserStartupAction browserStartupAction;

    public BrowserShutdownAction(BrowserStartupAction browserStartupAction) {
        this.browserStartupAction = browserStartupAction;
    }

    public void run() {
        List<Process> list = this.browserStartupAction.getProcesses();
        for (Process process : list) {
            try {
                process.destroy();
                if (process.exitValue() == 0) continue;
                LOGGER.warn("Unexpected shutdown " + process + " " + process.exitValue());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                LOGGER.warn("Process refused to exit" + process);
            }
        }
    }
}

