/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.ActionSequenceBuilder;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ThreadedAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.guice.DefaultThreadedActionProvider;
import com.google.jstestdriver.hooks.ActionListProcessor;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultActionListProvider
implements ActionListProvider {
    private final ActionFactory actionFactory;
    private final FileLoader fileLoader;
    private final List<String> tests;
    private final List<String> arguments;
    private final List<String> browsers;
    private final boolean reset;
    private final List<String> dryRunFor;
    private final int port;
    private final String server;
    private final boolean preloadFiles;
    private final Set<FileInfo> fileSet;
    private final String testOutput;
    private final ResponseStreamFactory responseStreamFactory;
    private final Provider<List<ThreadedAction>> threadedActionProvider;
    private final Provider<JsTestDriverClient> clientProvider;
    private final Provider<URLTranslator> urlTranslatorProvider;
    private final Provider<URLRewriter> urlRewriterProvider;
    private final FailureAccumulator accumulator;
    private final Set<ActionListProcessor> processors;
    private final XmlPrinter xmlPrinter;

    @Inject
    public DefaultActionListProvider(ActionFactory actionFactory, FileLoader fileLoader, @Named(value="tests") List<String> list, @Named(value="arguments") List<String> list2, @Named(value="browsers") List<String> list3, @Named(value="reset") boolean bl, @Named(value="dryRunFor") List<String> list4, @Named(value="preloadFiles") boolean bl2, @Named(value="port") int n, @Named(value="fileSet") Set<FileInfo> set, @Named(value="server") String string, @Named(value="testOutput") String string2, ResponseStreamFactory responseStreamFactory, DefaultThreadedActionProvider defaultThreadedActionProvider, Provider<JsTestDriverClient> provider, Provider<URLTranslator> provider2, Provider<URLRewriter> provider3, FailureAccumulator failureAccumulator, Set<ActionListProcessor> set2, XmlPrinter xmlPrinter) {
        this.actionFactory = actionFactory;
        this.fileLoader = fileLoader;
        this.tests = list;
        this.arguments = list2;
        this.browsers = list3;
        this.reset = bl;
        this.dryRunFor = list4;
        this.preloadFiles = bl2;
        this.port = n;
        this.fileSet = set;
        this.server = string;
        this.testOutput = string2;
        this.responseStreamFactory = responseStreamFactory;
        this.threadedActionProvider = defaultThreadedActionProvider;
        this.clientProvider = provider;
        this.urlTranslatorProvider = provider2;
        this.urlRewriterProvider = provider3;
        this.accumulator = failureAccumulator;
        this.processors = set2;
        this.xmlPrinter = xmlPrinter;
    }

    @Override
    @Provides
    public List<Action> get() {
        ActionSequenceBuilder actionSequenceBuilder = new ActionSequenceBuilder(this.actionFactory, this.fileLoader, this.responseStreamFactory, this.threadedActionProvider, this.clientProvider, this.urlTranslatorProvider, this.urlRewriterProvider, this.accumulator);
        actionSequenceBuilder.usingFiles(this.fileSet, this.preloadFiles).addTests(this.tests).addCommands(this.arguments).onBrowsers(this.browsers).reset(this.reset).asDryRunFor(this.dryRunFor).withLocalServerPort(this.port).withRemoteServer(this.server);
        if (this.testOutput.length() > 0) {
            actionSequenceBuilder.printingResultsWhenFinished(this.xmlPrinter);
        }
        List<Action> list = actionSequenceBuilder.build();
        for (ActionListProcessor actionListProcessor : this.processors) {
            list = actionListProcessor.process(list);
        }
        return list;
    }
}

