/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.DryRunInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ThreadedAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryRunAction
extends ThreadedAction {
    private final List<String> expressions;

    public DryRunAction(ResponseStreamFactory responseStreamFactory, List<String> list) {
        super(responseStreamFactory);
        this.expressions = list;
    }

    @Override
    public void run(String string, JsTestDriverClient jsTestDriverClient) {
        if (this.expressions.size() == 1 && this.expressions.get(0).equals("all")) {
            jsTestDriverClient.dryRun(string, this.responseStreamFactory.getDryRunActionResponseStream());
        } else {
            jsTestDriverClient.dryRunFor(string, this.responseStreamFactory.getDryRunActionResponseStream(), this.expressions);
        }
    }

    public static class DryRunActionResponseStream
    implements ResponseStream {
        private final Gson gson = new Gson();

        public void finish() {
        }

        public void stream(Response response) {
            BrowserInfo browserInfo = response.getBrowser();
            DryRunInfo dryRunInfo = this.gson.fromJson(response.getResponse(), DryRunInfo.class);
            System.out.println(String.format("%s %s: %s tests %s", browserInfo.getName(), browserInfo.getVersion(), dryRunInfo.getNumTests(), dryRunInfo.getTestNames()));
        }
    }
}

