/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcher.class.getName());
    private static final List<String> EMPTY_STRING_LIST = new ArrayList<String>();
    private final Map<String, Long> filesCache = new HashMap<String, Long>();
    private final File basePath;
    private final Set<String> files;

    public FileWatcher(File file, Set<String> set) {
        this.basePath = file;
        this.files = set;
        this.initFilesCache();
    }

    private void initFilesCache() {
        for (String string : this.files) {
            File file = new File(this.basePath, string);
            this.filesCache.put(string, file.lastModified());
        }
    }

    public void whitelist(Set<String> set) {
        this.files.addAll(set);
    }

    public List<String> getAllFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.files) {
            File file = new File(this.basePath, string);
            Long l = this.filesCache.get(string);
            if (l != null && l.compareTo(file.lastModified()) >= 0) continue;
            logger.info("{} changed, will be updated on the next command.", (Object)file.getPath());
            this.filesCache.put(string, file.lastModified());
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        return EMPTY_STRING_LIST;
    }
}

