/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Server;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServer
implements Server {
    @Override
    public String fetch(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.connect();
            String string2 = this.toString(httpURLConnection.getInputStream());
            return string2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private String toString(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            stringBuilder.append((char)n);
        }
        inputStream.close();
        return stringBuilder.toString();
    }

    @Override
    public String post(String string, Map<String, String> map) {
        HttpURLConnection httpURLConnection = null;
        try {
            String string2 = this.convertParamsToString(map);
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string2.getBytes().length));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
            outputStreamWriter.write(string2);
            outputStreamWriter.close();
            httpURLConnection.connect();
            String string3 = this.toString(httpURLConnection.getInputStream());
            return string3;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public String convertParamsToString(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuilder.append(String.format("%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8")));
            while (iterator.hasNext()) {
                entry = iterator.next();
                stringBuilder.append(String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8")));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String startSession(String string, String string2) {
        return this.fetch(string + "/fileSet?id=" + string2 + "&session=start");
    }

    @Override
    public void stopSession(String string, String string2, String string3) {
        this.fetch(string + "/fileSet?id=" + string2 + "&session=stop" + "&sessionId=" + string3);
    }
}

