/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactoryModule;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.ConfigurationParser;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetProvider;
import com.google.jstestdriver.FlagsImpl;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.guice.FlagsModule;
import com.google.jstestdriver.html.HtmlDocModule;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEPluginActionBuilder {
    private final ConfigurationParser configParser;
    private final String serverAddress;
    private final ResponseStreamFactory responseStreamFactory;
    private List<String> tests = new LinkedList<String>();
    private final LinkedList<Module> modules = new LinkedList();
    private boolean reset = false;
    private List<String> dryRunFor = new LinkedList<String>();

    public IDEPluginActionBuilder(ConfigurationParser configurationParser, String string, ResponseStreamFactory responseStreamFactory) {
        this.configParser = configurationParser;
        this.serverAddress = string;
        this.responseStreamFactory = responseStreamFactory;
    }

    public IDEPluginActionBuilder addAllTests() {
        this.tests.add("all");
        return this;
    }

    public IDEPluginActionBuilder addTests(List<String> list) {
        this.tests.addAll(list);
        return this;
    }

    public IDEPluginActionBuilder dryRunFor(List<String> list) {
        this.dryRunFor.addAll(list);
        return this;
    }

    public IDEPluginActionBuilder resetBrowsers() {
        this.reset = true;
        return this;
    }

    public IDEPluginActionBuilder install(Module module) {
        this.modules.add(module);
        return this;
    }

    public ActionRunner build() {
        this.configParser.parse();
        this.modules.add(new HtmlDocModule());
        Injector injector = Guice.createInjector(new ActionFactoryModule(), new ConfigurationModule(this.modules, this.tests, this.reset, this.dryRunFor, this.serverAddress != null ? this.serverAddress : this.configParser.getServer(), this.configParser.getFilesList(), this.responseStreamFactory));
        return injector.getInstance(ActionRunner.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationModule
    extends AbstractModule {
        private final List<String> tests;
        private final boolean reset;
        private final List<String> dryRunFor;
        private final String serverAddress;
        private final Set<FileInfo> fileSet;
        private final ResponseStreamFactory responseStreamFactory;
        private final LinkedList<Module> modules;

        public ConfigurationModule(LinkedList<Module> linkedList, List<String> list, boolean bl, List<String> list2, String string, Set<FileInfo> set, ResponseStreamFactory responseStreamFactory) {
            this.modules = linkedList;
            this.tests = list;
            this.reset = bl;
            this.dryRunFor = list2;
            this.serverAddress = string;
            this.fileSet = set;
            this.responseStreamFactory = responseStreamFactory;
        }

        @Override
        protected void configure() {
            FlagsImpl flagsImpl = new FlagsImpl();
            flagsImpl.setTests(this.tests);
            flagsImpl.setReset(this.reset);
            flagsImpl.setDryRunFor(this.dryRunFor);
            this.install(new FlagsModule(flagsImpl));
            this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("originalFileSet")).toInstance(this.fileSet);
            this.bind(String.class).annotatedWith(Names.named("server")).toInstance(this.serverAddress);
            this.bind(new TypeLiteral<List<Action>>(){}).toProvider(ActionListProvider.class);
            this.bind(ResponseStreamFactory.class).toInstance(this.responseStreamFactory);
            for (Module module : this.modules) {
                this.install(module);
            }
            this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("fileSet")).toProvider(FileSetProvider.class).in(Singleton.class);
        }
    }
}

