/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactoryModule;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetProvider;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.guice.FlagsModule;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverModule
extends AbstractModule {
    private final Flags flags;
    private final Set<FileInfo> fileSet;
    private final List<Module> plugins;
    private final String serverAddress;

    public JsTestDriverModule(Flags flags, Set<FileInfo> set, List<Module> list, String string) {
        this.flags = flags;
        this.fileSet = set;
        this.plugins = list;
        this.serverAddress = string;
    }

    @Override
    protected void configure() {
        this.bind(String.class).annotatedWith(Names.named("server")).toInstance(this.serverAddress);
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("originalFileSet")).toInstance(this.fileSet);
        this.bind(new TypeLiteral<List<Action>>(){}).toProvider(ActionListProvider.class);
        this.bind(FailureAccumulator.class).in(Singleton.class);
        this.install(new FlagsModule(this.flags));
        this.install(new ActionFactoryModule());
        for (Module module : this.plugins) {
            this.install(module);
        }
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("fileSet")).toProvider(FileSetProvider.class).in(Singleton.class);
        this.bind(Integer.class).annotatedWith(BrowserCount.class).toProvider(BrowserCountProvider.class).in(Singleton.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowserCountProvider
    implements Provider<Integer> {
        private final JsTestDriverClient client;

        @Inject
        public BrowserCountProvider(JsTestDriverClient jsTestDriverClient) {
            this.client = jsTestDriverClient;
        }

        @Override
        public synchronized Integer get() {
            try {
                return this.client.listBrowsers().size();
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot inject the browser count until the server has started. Try injecting a Provider of it instead.", exception);
            }
        }
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BrowserCount {
    }
}

