/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.BrowserHunter;
import com.google.jstestdriver.BrowserQueryResponseServlet;
import com.google.jstestdriver.CaptureServlet;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.CommandServlet;
import com.google.jstestdriver.DefaultPathRewriter;
import com.google.jstestdriver.FileCacheServlet;
import com.google.jstestdriver.FileSetServlet;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.FlagsParser;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.ForwardingServlet;
import com.google.jstestdriver.HeartbeatServlet;
import com.google.jstestdriver.HelloServlet;
import com.google.jstestdriver.HomeServlet;
import com.google.jstestdriver.JsTestDriverModule;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.SlaveResourceServlet;
import com.google.jstestdriver.StandaloneRunnerFilesFilterImpl;
import com.google.jstestdriver.StandaloneRunnerServlet;
import com.google.jstestdriver.TestResourceServlet;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.DefaultConfiguration;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.guice.TestResultPrintingModule;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import com.google.jstestdriver.html.HtmlDocModule;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;
import javax.servlet.Servlet;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class JsTestDriverServer
extends Observable {
    private final Server server = new Server();
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache filesCache;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private Context context;

    public JsTestDriverServer(int n, CapturedBrowsers capturedBrowsers, FilesCache filesCache, URLTranslator uRLTranslator, URLRewriter uRLRewriter) {
        this.port = n;
        this.capturedBrowsers = capturedBrowsers;
        this.filesCache = filesCache;
        this.urlTranslator = uRLTranslator;
        this.urlRewriter = uRLRewriter;
        this.initJetty(this.port);
        this.initServlets();
    }

    private void initServlets() {
        ForwardingMapper forwardingMapper = new ForwardingMapper();
        this.addServlet("/", new HomeServlet(this.capturedBrowsers));
        this.addServlet("/hello", new HelloServlet());
        this.addServlet("/heartbeat", new HeartbeatServlet(this.capturedBrowsers));
        this.addServlet("/capture", new CaptureServlet(new BrowserHunter(this.capturedBrowsers)));
        this.addServlet("/runner/*", new StandaloneRunnerServlet(new BrowserHunter(this.capturedBrowsers), this.filesCache, new StandaloneRunnerFilesFilterImpl(), new SlaveResourceService("/com/google/jstestdriver/javascript")));
        this.addServlet("/slave/*", new SlaveResourceServlet(new SlaveResourceService("/com/google/jstestdriver/javascript")));
        this.addServlet("/cmd", new CommandServlet(this.capturedBrowsers, this.urlTranslator, this.urlRewriter, forwardingMapper));
        this.addServlet("/query/*", new BrowserQueryResponseServlet(this.capturedBrowsers, this.urlTranslator, forwardingMapper));
        this.addServlet("/fileSet", new FileSetServlet(this.capturedBrowsers, this.filesCache));
        this.addServlet("/cache", new FileCacheServlet());
        this.addServlet("/test/*", new TestResourceServlet(this.filesCache));
        this.addServlet("/forward/*", new ForwardingServlet(forwardingMapper, "localhost", this.port));
    }

    private void addServlet(String string, Servlet servlet) {
        this.context.addServlet(new ServletHolder(servlet), string);
    }

    private void initJetty(int n) {
        SocketConnector socketConnector = new SocketConnector();
        socketConnector.setPort(n);
        this.server.addConnector(socketConnector);
        this.context = new Context(this.server, "/", 1);
        this.context.setMaxFormContentSize(Integer.MAX_VALUE);
    }

    public void start() {
        try {
            this.server.start();
            this.setChanged();
            this.notifyObservers((Object)Event.STARTED);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void stop() {
        try {
            this.server.stop();
            this.setChanged();
            this.notifyObservers((Object)Event.STOPPED);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            YamlParser yamlParser = new YamlParser(new DefaultPathRewriter(), Collections.<FileParsePostProcessor>emptySet());
            Flags flags = new FlagsParser().parseArgument(stringArray);
            File file = new File(flags.getConfig());
            LinkedList<Module> linkedList = Lists.newLinkedList();
            linkedList.add(new TestResultPrintingModule(System.out, flags.getTestOutput()));
            Configuration configuration = new DefaultConfiguration();
            if (flags.hasWork()) {
                if (!file.exists()) {
                    throw new RuntimeException("Config file doesn't exist: " + flags.getConfig());
                }
                configuration = yamlParser.parse(file.getParentFile(), new FileReader(file));
                linkedList.addAll(new PluginLoader().load(configuration.getPlugins()));
                linkedList.add(new HtmlDocModule());
            }
            Injector injector = Guice.createInjector(new JsTestDriverModule(flags, configuration.getFilesList(), linkedList, configuration.createServerAddress(flags.getServer(), flags.getPort())));
            injector.getInstance(ActionRunner.class).runActions();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        STARTED,
        STOPPED;

    }
}

