/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.ObservableAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStartupAction
implements ObservableAction {
    private static final Logger logger = LoggerFactory.getLogger(ServerStartupAction.class);
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache preloadedFilesCache;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private JsTestDriverServer server;
    private List<Observer> observerList = new LinkedList<Observer>();

    public ServerStartupAction(int n, CapturedBrowsers capturedBrowsers, FilesCache filesCache, URLTranslator uRLTranslator, URLRewriter uRLRewriter) {
        this.port = n;
        this.capturedBrowsers = capturedBrowsers;
        this.preloadedFilesCache = filesCache;
        this.urlTranslator = uRLTranslator;
        this.urlRewriter = uRLRewriter;
    }

    public JsTestDriverServer getServer() {
        return this.server;
    }

    @Override
    public void run() {
        logger.debug("Starting server...");
        this.server = new JsTestDriverServer(this.port, this.capturedBrowsers, this.preloadedFilesCache, this.urlTranslator, this.urlRewriter);
        for (Observer observer : this.observerList) {
            this.server.addObserver(observer);
        }
        this.server.start();
    }

    @Override
    public void addObservers(List<Observer> list) {
        this.observerList.addAll(list);
    }
}

