/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLQueryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLQueryParser.class);
    private final String query;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private boolean parsed = false;

    public URLQueryParser(String string) {
        this.query = string;
    }

    public void parse() {
        if (!this.parsed) {
            String[] stringArray;
            if (this.query == null) {
                this.parsed = true;
                return;
            }
            String string = this.query;
            int n = this.query.indexOf("?");
            if (n != -1) {
                string = this.query.substring(n + 1);
            }
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=", 2);
                String string3 = "";
                String string4 = "";
                try {
                    string3 = URLDecoder.decode(stringArray2[0], "UTF-8");
                    string4 = stringArray2.length == 2 ? URLDecoder.decode(stringArray2[1], "UTF-8") : "";
                    this.parameters.put(string3, string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.warn("Could not decode: [ " + string3 + ", " + string4 + " ]", unsupportedEncodingException);
                }
            }
            this.parsed = true;
        }
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }
}

