/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.directoryscanner;

import com.google.jstestdriver.directoryscanner.DirectoryScannerException;
import com.google.jstestdriver.directoryscanner.FileScanner;
import com.google.jstestdriver.directoryscanner.FileSelector;
import com.google.jstestdriver.directoryscanner.FileUtils;
import com.google.jstestdriver.directoryscanner.Os;
import com.google.jstestdriver.directoryscanner.SelectorScanner;
import com.google.jstestdriver.directoryscanner.SelectorUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner
implements FileScanner,
SelectorScanner {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    private static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS = new boolean[]{true, false};
    private static Vector<String> defaultExcludes = new Vector();
    private File basedir;
    private String[] includes;
    private String[] excludes;
    private FileSelector[] selectors = null;
    private Vector<String> filesIncluded;
    private Vector<String> filesNotIncluded;
    private Vector<String> filesExcluded;
    private Vector<String> dirsIncluded;
    private Vector<String> dirsNotIncluded;
    private Vector<String> dirsExcluded;
    private Vector<String> filesDeselected;
    private Vector<String> dirsDeselected;
    private boolean haveSlowResults = false;
    private boolean isCaseSensitive = true;
    private boolean errorOnMissingDir = true;
    private boolean followSymlinks = true;
    private boolean everythingIncluded = true;
    private Map<File, String[]> fileListMap = new HashMap<File, String[]>();
    private Set<String> scannedDirs = new HashSet<String>();
    private Set<String> includeNonPatterns = new HashSet<String>();
    private Set<String> excludeNonPatterns = new HashSet<String>();
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private Object scanLock = new Object();
    private boolean slowScanning = false;
    private Object slowScanLock = new Object();
    private IllegalStateException illegal = null;

    protected static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl) {
        return SelectorUtils.matchPatternStart(string, string2, bl);
    }

    protected static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2);
    }

    protected static boolean matchPath(String string, String string2, boolean bl) {
        return SelectorUtils.matchPath(string, string2, bl);
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2);
    }

    protected static boolean match(String string, String string2, boolean bl) {
        return SelectorUtils.match(string, string2, bl);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String string) {
        if (defaultExcludes.indexOf(string) == -1) {
            defaultExcludes.add(string);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String string) {
        return defaultExcludes.remove(string);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
        }
    }

    @Override
    public void setBasedir(String string) {
        this.setBasedir(string == null ? (File)null : new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    @Override
    public synchronized void setBasedir(File file) {
        this.basedir = file;
    }

    @Override
    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public synchronized void setCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public void setErrorOnMissingDir(boolean bl) {
        this.errorOnMissingDir = bl;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    @Override
    public synchronized void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.includes[i] = DirectoryScanner.normalizePattern(stringArray[i]);
            }
        }
    }

    @Override
    public synchronized void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.excludes[i] = DirectoryScanner.normalizePattern(stringArray[i]);
            }
        }
    }

    public synchronized void addExcludes(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] stringArray2 = new String[stringArray.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, stringArray2, 0, this.excludes.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[this.excludes.length + i] = DirectoryScanner.normalizePattern(stringArray[i]);
                }
                this.excludes = stringArray2;
            } else {
                this.setExcludes(stringArray);
            }
        }
    }

    private static String normalizePattern(String string) {
        String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (string2.endsWith(File.separator)) {
            string2 = string2 + "**";
        }
        return string2;
    }

    @Override
    public synchronized void setSelectors(FileSelector[] fileSelectorArray) {
        this.selectors = fileSelectorArray;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void scan() throws IllegalStateException {
        block42: {
            var1_1 = this.scanLock;
            synchronized (var1_1) {
                if (this.scanning) {
                    while (this.scanning) {
                        try {
                            this.scanLock.wait();
                        }
                        catch (InterruptedException var2_2) {}
                    }
                    if (this.illegal != null) {
                        throw this.illegal;
                    }
                    return;
                }
                this.scanning = true;
            }
            var1_1 = this;
            synchronized (var1_1) {
                this.illegal = null;
                this.clearResults();
                v0 = var2_3 = this.includes == null;
                if (var2_3) {
                    v1 = new String[1];
                    v2 = v1;
                    v1[0] = "**";
                } else {
                    v2 = this.includes;
                }
                this.includes = v2;
                var3_5 = this.excludes == null;
                v3 = this.excludes = var3_5 != false ? new String[]{} : this.excludes;
                if (this.basedir != null) ** break block40
                if (!var2_3) ** GOTO lbl69
                // MONITOREXIT @DISABLED, blocks:[2, 3, 12] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                var4_6 = this.scanLock;
            }
            synchronized (var4_6) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
            return;
            {
                if (this.basedir.exists()) ** break block41
                if (this.errorOnMissingDir) {
                    this.illegal = new IllegalStateException("basedir " + this.basedir + " does not exist");
                    ** break block41
                }
                // MONITOREXIT @DISABLED, blocks:[5, 12] lbl56 : MonitorExitStatement: MONITOREXIT : var1_1
                var4_7 = this.scanLock;
            }
            synchronized (var4_7) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
            return;
lbl-1000:
            // 2 sources

            {
                if (!this.basedir.isDirectory()) {
                    this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a directory");
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
lbl69:
                // 3 sources

                if (this.isIncluded("")) {
                    if (!this.isExcluded("")) {
                        if (this.isSelected("", this.basedir)) {
                            this.dirsIncluded.addElement("");
                        } else {
                            this.dirsDeselected.addElement("");
                        }
                    } else {
                        this.dirsExcluded.addElement("");
                    }
                } else {
                    this.dirsNotIncluded.addElement("");
                }
                this.checkIncludePatterns();
                this.clearCaches();
                this.includes = var2_3 != false ? null : this.includes;
                this.excludes = var3_5 != false ? null : this.excludes;
                break block42;
                {
                    catch (Throwable var7_10) {
                        throw var7_10;
                    }
                }
            }
            {
                finally {
                    var1_1 = this.scanLock;
                    synchronized (var1_1) {
                        this.scanning = false;
                        this.scanLock.notifyAll();
                    }
                }
            }
        }
    }

    private void checkIncludePatterns() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.includes.length; ++i) {
            if (FileUtils.isAbsolutePath(this.includes[i]) ? this.basedir != null && !SelectorUtils.matchPatternStart(this.includes[i], this.basedir.getAbsolutePath(), this.isCaseSensitive()) : this.basedir == null) continue;
            hashMap.put(SelectorUtils.rtrimWildcardTokens(this.includes[i]), this.includes[i]);
        }
        if (hashMap.containsKey("") && this.basedir != null) {
            this.scandir(this.basedir, "", true);
        } else {
            Iterator iterator = hashMap.entrySet().iterator();
            File file = null;
            if (this.basedir != null) {
                try {
                    file = this.basedir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    throw new DirectoryScannerException(iOException);
                }
            }
            while (iterator.hasNext()) {
                Object object;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (this.basedir == null && !FileUtils.isAbsolutePath(string)) continue;
                String string2 = (String)entry.getValue();
                Object object2 = new File(this.basedir, string);
                if (((File)object2).exists()) {
                    try {
                        Object object3 = object = this.basedir == null ? ((File)object2).getCanonicalPath() : FILE_UTILS.removeLeadingPath(file, ((File)object2).getCanonicalFile());
                        if ((!((String)object).equals(string) || ON_VMS) && (object2 = this.findFile(this.basedir, string, true)) != null && this.basedir != null) {
                            string = FILE_UTILS.removeLeadingPath(this.basedir, (File)object2);
                        }
                    }
                    catch (IOException iOException) {
                        throw new DirectoryScannerException(iOException);
                    }
                }
                if (!(object2 != null && ((File)object2).exists() || this.isCaseSensitive() || (object = this.findFile(this.basedir, string, false)) == null || !((File)object).exists())) {
                    string = this.basedir == null ? ((File)object).getAbsolutePath() : FILE_UTILS.removeLeadingPath(this.basedir, (File)object);
                    object2 = object;
                }
                if (object2 == null || !((File)object2).exists() || !this.followSymlinks && this.isSymlink(this.basedir, string)) continue;
                if (((File)object2).isDirectory()) {
                    if (this.isIncluded(string) && string.length() > 0) {
                        this.accountForIncludedDir(string, (File)object2, true);
                        continue;
                    }
                    if (string.length() > 0 && string.charAt(string.length() - 1) != File.separatorChar) {
                        string = string + File.separatorChar;
                    }
                    this.scandir((File)object2, string, true);
                    continue;
                }
                boolean bl = this.isCaseSensitive() ? string2.equals(string) : string2.equalsIgnoreCase(string);
                if (!bl) continue;
                this.accountForIncludedFile(string, (File)object2);
            }
        }
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slowScan() {
        Object object = this.slowScanLock;
        synchronized (object) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                String[] stringArray;
                boolean bl;
                boolean bl2 = bl = this.includes == null;
                if (bl) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean bl3 = this.excludes == null;
                this.excludes = bl3 ? new String[]{} : this.excludes;
                Object[] objectArray = new String[this.dirsExcluded.size()];
                this.dirsExcluded.copyInto(objectArray);
                Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
                this.dirsNotIncluded.copyInto(objectArray2);
                this.processSlowScan((String[])objectArray);
                this.processSlowScan((String[])objectArray2);
                this.clearCaches();
                this.includes = bl ? null : this.includes;
                this.excludes = bl3 ? null : this.excludes;
            }
        }
        finally {
            object = this.slowScanLock;
            synchronized (object) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
        }
    }

    private void processSlowScan(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.couldHoldIncluded(stringArray[i])) continue;
            this.scandir(new File(this.basedir, stringArray[i]), stringArray[i] + File.separator, false);
        }
    }

    protected void scandir(File file, String string, boolean bl) {
        if (file == null) {
            throw new DirectoryScannerException("dir must not be null.");
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            if (!file.exists()) {
                throw new DirectoryScannerException(file + " doesn't exist.");
            }
            if (!file.isDirectory()) {
                throw new DirectoryScannerException(file + " is not a directory.");
            }
            throw new DirectoryScannerException("IO error scanning directory '" + file.getAbsolutePath() + "'");
        }
        this.scandir(file, string, bl, stringArray);
    }

    private void scandir(File file, String string, boolean bl, String[] stringArray) {
        Object object;
        Object object2;
        if (bl && this.hasBeenScanned(string)) {
            return;
        }
        if (!this.followSymlinks) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    if (FILE_UTILS.isSymbolicLink(file, stringArray[i])) {
                        object2 = string + stringArray[i];
                        object = new File(file, stringArray[i]);
                        (((File)object).isDirectory() ? this.dirsExcluded : this.filesExcluded).addElement((String)object2);
                        continue;
                    }
                    vector.addElement(stringArray[i]);
                    continue;
                }
                catch (IOException iOException) {
                    object = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println((String)object);
                    vector.addElement(stringArray[i]);
                }
            }
            stringArray = vector.toArray(new String[vector.size()]);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + stringArray[i];
            object2 = new File(file, stringArray[i]);
            object = ((File)object2).list();
            if (object == null) {
                if (this.isIncluded(string2)) {
                    this.accountForIncludedFile(string2, (File)object2);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesNotIncluded.addElement(string2);
                continue;
            }
            if (this.isIncluded(string2)) {
                this.accountForIncludedDir(string2, (File)object2, bl, (String[])object);
            } else {
                this.everythingIncluded = false;
                this.dirsNotIncluded.addElement(string2);
                if (bl && this.couldHoldIncluded(string2)) {
                    this.scandir((File)object2, string2 + File.separator, bl, (String[])object);
                }
            }
            if (bl) continue;
            this.scandir((File)object2, string2 + File.separator, bl, (String[])object);
        }
    }

    private void accountForIncludedFile(String string, File file) {
        this.processIncluded(string, file, this.filesIncluded, this.filesExcluded, this.filesDeselected);
    }

    private void accountForIncludedDir(String string, File file, boolean bl) {
        this.processIncluded(string, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (bl && this.couldHoldIncluded(string) && !this.contentsExcluded(string)) {
            this.scandir(file, string + File.separator, bl);
        }
    }

    private void accountForIncludedDir(String string, File file, boolean bl, String[] stringArray) {
        this.processIncluded(string, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (bl && this.couldHoldIncluded(string) && !this.contentsExcluded(string)) {
            this.scandir(file, string + File.separator, bl, stringArray);
        }
    }

    private void processIncluded(String string, File file, Vector<String> vector, Vector<String> vector2, Vector<String> vector3) {
        if (vector.contains(string) || vector2.contains(string) || vector3.contains(string)) {
            return;
        }
        boolean bl = false;
        if (this.isExcluded(string)) {
            vector2.add(string);
        } else if (this.isSelected(string, file)) {
            bl = true;
            vector.add(string);
        } else {
            vector3.add(string);
        }
        this.everythingIncluded &= bl;
    }

    protected boolean isIncluded(String string) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(string) : this.includeNonPatterns.contains(string.toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.includePatterns.length; ++i) {
            if (!DirectoryScanner.matchPath(this.includePatterns[i], string, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPatternStart(this.includes[i], string, this.isCaseSensitive()) || !this.isMorePowerfulThanExcludes(string, this.includes[i]) || !this.isDeeper(this.includes[i], string)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeeper(String string, String string2) {
        Vector vector = SelectorUtils.tokenizePath(string);
        Vector vector2 = SelectorUtils.tokenizePath(string2);
        return vector.contains("**") || vector.size() > vector2.size();
    }

    private boolean isMorePowerfulThanExcludes(String string, String string2) {
        String string3 = string + File.separator + "**";
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!this.excludes[i].equals(string3)) continue;
            return false;
        }
        return true;
    }

    private boolean contentsExcluded(String string) {
        string = string.endsWith(File.separator) ? string : string + File.separator;
        for (int i = 0; i < this.excludes.length; ++i) {
            String string2 = this.excludes[i];
            if (!string2.endsWith("**") || !SelectorUtils.matchPath(string2.substring(0, string2.length() - 2), string, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String string) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(string) : this.excludeNonPatterns.contains(string.toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.excludePatterns.length; ++i) {
            if (!DirectoryScanner.matchPath(this.excludePatterns[i], string, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String string, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, string, file)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] objectArray = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.filesIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized String[] getExcludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized String[] getDeselectedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized String[] getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] objectArray = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.dirsIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized String[] getExcludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + defaultExcludes.size()];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        String[] stringArray2 = DirectoryScanner.getDefaultExcludes();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[i + n] = stringArray2[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = stringArray;
    }

    private String[] list(File file) {
        String[] stringArray = this.fileListMap.get(file);
        if (stringArray == null && (stringArray = file.list()) != null) {
            this.fileListMap.put(file, stringArray);
        }
        return stringArray;
    }

    private File findFile(File file, String string, boolean bl) {
        if (FileUtils.isAbsolutePath(string)) {
            if (file == null) {
                String[] stringArray = FILE_UTILS.dissect(string);
                file = new File(stringArray[0]);
                string = stringArray[1];
            } else {
                File file2 = FILE_UTILS.normalize(string);
                String string2 = FILE_UTILS.removeLeadingPath(file, file2);
                if (string2.equals(file2.getAbsolutePath())) {
                    return null;
                }
                string = string2;
            }
        }
        return this.findFile(file, SelectorUtils.tokenizePath(string), bl);
    }

    private File findFile(File file, Vector<String> vector, boolean bl) {
        if (vector.size() == 0) {
            return file;
        }
        String string = vector.remove(0);
        if (file == null) {
            return this.findFile(new File(string), vector, bl);
        }
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = this.list(file);
        if (stringArray == null) {
            throw new DirectoryScannerException("IO error scanning directory " + file.getAbsolutePath());
        }
        boolean[] blArray = bl ? CS_SCAN_ONLY : CS_THEN_NON_CS;
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!(blArray[i] ? stringArray[j].equals(string) : stringArray[j].equalsIgnoreCase(string))) continue;
                return this.findFile(new File(file, stringArray[j]), vector, bl);
            }
        }
        return null;
    }

    private boolean isSymlink(File file, String string) {
        return this.isSymlink(file, SelectorUtils.tokenizePath(string));
    }

    private boolean isSymlink(File file, Vector<String> vector) {
        if (vector.size() > 0) {
            String string = vector.remove(0);
            try {
                return FILE_UTILS.isSymbolicLink(file, string) || this.isSymlink(new File(file, string), vector);
            }
            catch (IOException iOException) {
                String string2 = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(string2);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String string) {
        return !this.scannedDirs.add(string);
    }

    Set<String> getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set<String> set, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!SelectorUtils.hasWildcards(stringArray[i])) {
                set.add(this.isCaseSensitive() ? stringArray[i] : stringArray[i].toUpperCase());
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        return set.size() == 0 ? stringArray : arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
    }
}

