/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.directoryscanner;

import com.google.jstestdriver.directoryscanner.DirectoryScannerException;
import com.google.jstestdriver.directoryscanner.Os;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;

public class FileUtils {
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static final boolean ON_NETWARE = Os.isFamily("netware");
    private static final boolean ON_DOS = Os.isFamily("dos");
    static final int BUF_SIZE = 8192;
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;
    public static final long NTFS_FILE_TIMESTAMP_GRANULARITY = 1L;

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public static boolean isAbsolutePath(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = File.separatorChar;
        string = string.replace('/', c).replace('\\', c);
        char c2 = string.charAt(0);
        if (!ON_DOS && !ON_NETWARE) {
            return c2 == c;
        }
        if (c2 == c) {
            if (!ON_DOS || n <= 4 || string.charAt(1) != c) {
                return false;
            }
            int n2 = string.indexOf(c, 2);
            return n2 > 2 && n2 + 1 < n;
        }
        int n3 = string.indexOf(58);
        return Character.isLetter(c2) && n3 == 1 && string.length() > 2 && string.charAt(2) == c || ON_NETWARE && n3 > 0;
    }

    public File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String[] stringArray = this.dissect(string);
        stack.push(stringArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1], File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    public String[] dissect(String string) {
        char c = File.separatorChar;
        if (!FileUtils.isAbsolutePath(string = string.replace('/', c).replace('\\', c))) {
            throw new DirectoryScannerException(string + " is not an absolute path");
        }
        String string2 = null;
        int n = string.indexOf(58);
        if (n > 0 && (ON_DOS || ON_NETWARE)) {
            int n2 = n + 1;
            string2 = string.substring(0, n2);
            char[] cArray = string.toCharArray();
            string2 = string2 + c;
            n2 = cArray[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < cArray.length; ++i) {
                if (cArray[i] == c && cArray[i - 1] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        } else if (string.length() > 1 && string.charAt(1) == c) {
            int n3 = string.indexOf(c, 2);
            string2 = (n3 = string.indexOf(c, n3 + 1)) > 2 ? string.substring(0, n3 + 1) : string;
            string = string.substring(string2.length());
        } else {
            string2 = File.separator;
            string = string.substring(1);
        }
        return new String[]{string2, string};
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        File file2;
        if (file == null) {
            file2 = new File(string);
            file = file2.getParentFile();
            string = file2.getName();
        }
        return !(file2 = new File(file.getCanonicalPath(), string)).getAbsolutePath().equals(file2.getCanonicalPath());
    }

    public String removeLeadingPath(File file, File file2) {
        String string;
        String string2 = this.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (string2.equals(string = this.normalize(file2.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2) ? string.substring(string2.length()) : string;
    }
}

