/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.jstestdriver.html.BlockNodeFactory;
import com.google.jstestdriver.html.HtmlDocGlobalNode;
import com.google.jstestdriver.html.HtmlDocNestedNode;
import com.google.jstestdriver.html.HtmlDocNodeFactory;
import com.google.jstestdriver.html.TextNode;
import com.google.jstestdriver.token.BufferedTokenStream;
import com.google.jstestdriver.token.Nodes;
import com.google.jstestdriver.token.Token;

public class HtmlDocParser {
    public Nodes parse(BufferedTokenStream bufferedTokenStream) {
        Nodes nodes = new Nodes();
        NodeFactory[] nodeFactoryArray = new NodeFactory[]{new HtmlDocNodeFactory(new HtmlDocGlobalNode.GlobalNodeStrategy()), new BlockNodeFactory(new NodeFactory[]{new HtmlDocNodeFactory(new HtmlDocNestedNode.NestedNodeStrategy()), new TextNodeFactory()}), new TextNodeFactory()};
        while (bufferedTokenStream.available()) {
            for (NodeFactory nodeFactory : nodeFactoryArray) {
                nodeFactory.create(bufferedTokenStream, nodes);
            }
        }
        return nodes;
    }

    public static interface NodeFactory {
        public void create(BufferedTokenStream var1, Nodes var2);
    }

    public static class TextNodeFactory
    implements NodeFactory {
        public void create(BufferedTokenStream bufferedTokenStream, Nodes nodes) {
            Token token = bufferedTokenStream.read();
            if (token == null) {
                return;
            }
            nodes.add(new TextNode(token));
            bufferedTokenStream.mark();
        }
    }
}

