/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.FailureParser;
import com.google.jstestdriver.JsTestDriverModule;
import com.google.jstestdriver.RunData;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.TestResultListener;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListener
implements TestResultListener {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final PrintStream out;
    private final AtomicInteger browsers;
    private final boolean verbose;
    private final Map<String, RunData> browsersRunData = new ConcurrentHashMap<String, RunData>();
    private final AtomicInteger lineColumn = new AtomicInteger(0);
    private final AtomicInteger totalPasses = new AtomicInteger(0);
    private final AtomicInteger totalFails = new AtomicInteger(0);
    private final AtomicInteger totalErrors = new AtomicInteger(0);
    private int lineLength = 70;

    @Inject
    public DefaultListener(@Named(value="outputStream") PrintStream printStream, @JsTestDriverModule.BrowserCount Provider<Integer> provider, @Named(value="verbose") boolean bl) {
        this.out = printStream;
        this.browsers = new AtomicInteger(provider.get());
        this.verbose = bl;
    }

    public void setLineLength(int n) {
        this.lineLength = n;
    }

    @Override
    public void finish() {
        if (this.browsers.decrementAndGet() == 0) {
            if (!this.verbose) {
                this.out.println();
            }
            this.out.println(String.format("Total %d tests (Passed: %d; Fails: %d; Errors: %d) (%.2f ms)", this.totalPasses.get() + this.totalFails.get() + this.totalErrors.get(), this.totalPasses.get(), this.totalFails.get(), this.totalErrors.get(), Float.valueOf(this.findMaxTime())));
            for (Map.Entry<String, RunData> entry : this.browsersRunData.entrySet()) {
                RunData runData = entry.getValue();
                this.out.println(String.format("  %s: Run %d tests (Passed: %d; Fails: %d; Errors %d) (%.2f ms)", entry.getKey(), runData.getPassed() + runData.getFailed() + runData.getErrors(), runData.getPassed(), runData.getFailed(), runData.getErrors(), Float.valueOf(runData.getTotalTime())));
                List<TestResult> list = runData.getProblems();
                for (TestResult testResult : list) {
                    String[] stringArray;
                    if (testResult.getResult() != TestResult.Result.passed) {
                        stringArray = new FailureParser();
                        stringArray.parse(testResult.getMessage());
                        String[] stringArray2 = stringArray.getMessage();
                        List<String> list2 = stringArray.getStack();
                        String string = "";
                        if (list2.size() > 0) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string2 : list2) {
                                stringBuilder.append(NEW_LINE + "      " + string2);
                            }
                            string = stringBuilder.toString();
                        }
                        this.out.println(String.format("    %s.%s %s (%.2f ms): %s%s", new Object[]{testResult.getTestCaseName(), testResult.getTestName(), testResult.getResult(), Float.valueOf(testResult.getTime()), stringArray2, string}));
                    } else {
                        this.out.println(String.format("    %s.%s %s (%.2f ms)", new Object[]{testResult.getTestCaseName(), testResult.getTestName(), testResult.getResult(), Float.valueOf(testResult.getTime())}));
                    }
                    if (this.verbose || testResult.getLog().length() <= 0) continue;
                    for (String string : stringArray = testResult.getLog().split("\n")) {
                        this.out.println("      " + string);
                    }
                }
            }
        }
    }

    private float findMaxTime() {
        float f = 0.0f;
        for (RunData runData : this.browsersRunData.values()) {
            f = Math.max(runData.getTotalTime(), f);
        }
        return f;
    }

    @Override
    public void onTestComplete(TestResult testResult) {
        String string = testResult.getBrowserInfo().toString();
        RunData runData = this.browsersRunData.get(string);
        if (runData == null) {
            runData = new RunData();
            this.browsersRunData.put(string, runData);
        }
        TestResult.Result result = testResult.getResult();
        String string2 = testResult.getLog();
        runData.addTime(testResult.getTime());
        if (result == TestResult.Result.passed) {
            if (!this.verbose) {
                this.out.print('.');
                if (string2.length() > 0) {
                    runData.addProblem(testResult);
                }
            } else {
                this.out.println("[PASSED] " + testResult.getTestCaseName() + "." + testResult.getTestName());
                if (string2.length() > 0) {
                    String[] stringArray;
                    for (String string3 : stringArray = string2.split("\n")) {
                        this.out.println("  " + string3);
                    }
                }
            }
            runData.addPass();
            this.totalPasses.incrementAndGet();
        } else if (result == TestResult.Result.failed) {
            if (!this.verbose) {
                this.out.print('F');
            } else {
                this.out.println("[FAILED] " + testResult.getTestCaseName() + "." + testResult.getTestName());
                if (string2.length() > 0) {
                    String[] stringArray;
                    for (String string4 : stringArray = string2.split("\n")) {
                        this.out.println("  " + string4);
                    }
                }
            }
            runData.addFail();
            runData.addProblem(testResult);
            this.totalFails.incrementAndGet();
        } else if (result == TestResult.Result.error) {
            if (!this.verbose) {
                this.out.print('E');
            } else {
                this.out.println("[ERROR] " + testResult.getTestCaseName() + "." + testResult.getTestName());
                if (string2.length() > 0) {
                    String[] stringArray;
                    for (String string5 : stringArray = string2.split("\n")) {
                        this.out.println("  " + string5);
                    }
                }
            }
            runData.addError();
            runData.addProblem(testResult);
            this.totalErrors.incrementAndGet();
        } else {
            this.out.print("<" + (Object)((Object)result) + ">");
            if (this.verbose) {
                this.out.println(" " + testResult.getTestCaseName() + "." + testResult.getTestName());
                if (string2.length() > 0) {
                    String[] stringArray;
                    for (String string6 : stringArray = string2.split("\n")) {
                        this.out.println("  " + string6);
                    }
                }
            }
            runData.addProblem(testResult);
        }
        if (this.lineColumn.incrementAndGet() == this.lineLength) {
            this.out.println();
            this.lineColumn.set(0);
        }
    }
}

